import { world, system, ItemStack } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:amethyst_ore', {
        onPlayerDestroy: (data) => {
            const player = data.player
            const block = data.block
            const { x, y, z } = block.location
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand');
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const enchantedTool = selectedItem?.getComponent('minecraft:enchantable')
            const fortune = enchantedTool.getEnchantment('fortune')?.level
            if (isPickaxe && player.getGameMode() !== "creative" && selectedItem?.typeId !== 'minecraft:wooden_pickaxe') {
                system.run(() => {
                    block.dimension.runCommand(`loot spawn ${Object.values(block.center()).join(' ')} loot amethyst_ore`)
                })
            }
        }
    })
})

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:tin_ore', {
        onPlayerDestroy: (data) => {
            const player = data.player
            const block = data.block
            const { x, y, z } = block.location
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand');
            const isPickaxe = selectedItem && selectedItem.hasTag('minecraft:is_pickaxe');
            const enchantedTool = selectedItem?.getComponent('minecraft:enchantable')
            const fortune = enchantedTool.getEnchantment('fortune')?.level
            if (isPickaxe && player.getGameMode() !== "creative" && selectedItem?.typeId !== 'minecraft:wooden_pickaxe') {
                system.run(() => {
                    block.dimension.spawnItem(new ItemStack('v360:raw_tin', 1), { x: x + 0.5, y: y + 0.5, z: z + 0.5 })
                })
            }
        }
    })
})